/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.capital.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.capital.local.config.CapitalRechargeProperties;
import com.biz.crm.cps.business.capital.local.config.RechargeProperties;
import com.biz.crm.cps.business.capital.sdk.dto.RechargeConditionDto;
import com.biz.crm.cps.business.capital.sdk.service.RechargeProcessVoService;
import com.biz.crm.cps.business.capital.sdk.service.observer.RechargeServiceObserver;
import com.biz.crm.cps.business.capital.sdk.vo.RechargeProcessVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RechargeProcessVoServiceImpl
implements RechargeProcessVoService {
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private List<RechargeServiceObserver> rechargeServiceObserverList;
    @Autowired(required=false)
    private CapitalRechargeProperties capitalRechargeProperties;

    public RechargeProcessVo findProcessByCurrentUser() {
        LoginUserDetailsForCPS userDetails = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        ParticipatorTypeEnum participatorTypeEnum = ParticipatorTypeEnum.getByKey((String)userDetails.getUsertype());
        RechargeConditionDto conditionDto = new RechargeConditionDto();
        conditionDto.setParticipatorFlag(participatorTypeEnum.getDictCode());
        conditionDto.setMerchantUserAccount(userDetails.getAccount());
        if (CollectionUtils.isEmpty(this.rechargeServiceObserverList)) {
            return null;
        }
        RechargeProcessVo cashProcessVo = null;
        for (RechargeServiceObserver rechargeServiceObserver : this.rechargeServiceObserverList) {
            List<RechargeProperties> rechargeProperties = this.capitalRechargeProperties.getRecharges();
            Validate.notEmpty(rechargeProperties, (String)"\u7cfb\u7edf\u7f3a\u5c11\u5145\u503c\u914d\u7f6e", (Object[])new Object[0]);
            RechargeProperties rechargeProp = rechargeProperties.stream().filter(item -> Objects.equals(conditionDto.getParticipatorFlag(), item.getParticipatorType())).findAny().orElse(null);
            Validate.notNull((Object)rechargeProp, (String)"\u7cfb\u7edf\u7f3a\u5c11\u3010%s\u3011\u7c7b\u578b\u7684\u5145\u503c\u914d\u7f6e", (Object[])new Object[]{conditionDto.getParticipatorFlag()});
            conditionDto.setRechargeKey(rechargeProp.getRechargeKey());
            cashProcessVo = rechargeServiceObserver.onRequestRechargeProcess(conditionDto);
        }
        return cashProcessVo;
    }
}

