package com.biz.crm.cps.business.capital.sdk.common.enums;

/**
 * @author wjx
 * @Description:资金收支业务类型
 **/
public enum BusinessTypeEnum {
  RECHARGE("0", "transactionRecharge", "充值", "1"),

  RED_PACKET("1", "transactionRedPacket", "红包发放", "2"),
  ;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  BusinessTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public static String getDictTypeCode() {
    return "RechargeStatusEnum";
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

}

