package com.biz.crm.cps.business.capital.sdk.common.enums;

/**
 * @author wjx
 * @Description:数据来源
 **/
public enum DataSourceEnum {
  TAX_ADD("1", "taxAdd", "税筹新增", "1"),

  TAX_PUSH("2", "taxPush", "税筹推送", "2"),

  CPS_ADD("3", "cpsAdd", "cps新增", "3"),

  CPS_PUSH("4", "cpsPush", "cps推送", "4")

  ;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  DataSourceEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

}

