package com.biz.crm.cps.business.capital.sdk.common.enums;

/**
 * @author wjx
 * @Description:充值审核状态
 **/
public enum RechargeAuditEnum {
  WAIT("1", "rechargeAuditWait", "待审核", "1"),

  PASS("2", "rechargeAuditPass", "通过", "2"),

  REJECT("3", "rechargeAuditReject", "驳回", "3"),
  ;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  RechargeAuditEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

}

