package com.biz.crm.cps.business.capital.sdk.common.enums;

/**
 * @author wjx
 * @Description:充值状态
 **/
public enum RechargeStatusEnum {
  WAIT("1", "rechargeWait", "待确认", "1"),

  CONFIRM("2", "rechargeConfirm", "已确认", "2"),

  FAIL("3", "rechargeFail", "失败", "3"),
  ;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  RechargeStatusEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public static String getDictTypeCode() {
    return "RechargeStatusEnum";
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

}

