package com.biz.crm.cps.business.capital.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 税筹修改充值状态信息dto
 * @Author: wjx
 * @Date: 2022/4/6 11:26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CpsRaiseRechargeUpdateStatusDto", description = "税筹修改充值状态信息dto")
public class CpsRaiseRechargeUpdateStatusDto {

  /**
   * 税筹充值编号集合
   */
  @ApiModelProperty("税筹充值编号集合")
  private List<String> pushCodes;

  /**
   * 审核状态
   */
  @ApiModelProperty("审核状态")
  private String auditStatus;

  /**
   * 充值状态
   */
  @ApiModelProperty("充值状态")
  private String rechargeStatus;
}
