package com.biz.crm.cps.business.capital.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 充值账号信息dto
 *
 * @Author: wjx
 * @Date: 2022/2/17 11:15
 */
@Data
@ApiModel(value = "RechargeAccountDto", description = "充值账号信息dto")
public class RechargeAccountDto {

  /**
   * 商户平台用户账户 (通过该编码+商户平台id 可查询税筹平台的账户userAccount)
   */
  @ApiModelProperty("商户平台用户账户")
  private String merchantUserAccount;

  /**
   * 账户编码(cps中的 账户编码  = 税筹平台的 商户平台用户账户)
   */
  @ApiModelProperty("账户编码")
  private String accountCode;

  /**
   * 充值金额
   */
  @ApiModelProperty("充值金额")
  private BigDecimal rechargeAmount;


}
