package com.biz.crm.cps.business.capital.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 充值条件Dto
 * @Author: wjx
 */
@Data
@ApiModel(value = "RechargeConditionDto", description = "充值条件Dto")
public class RechargeConditionDto {

  /**
   * 商户平台用户账户 (通过该编码+商户平台id 可查询税筹平台的账户userAccount)
   */
  @ApiModelProperty("商户平台用户账户")
  private String merchantUserAccount;
  /**
   * 充值类型 税筹充值
   */
  @ApiModelProperty("充值类型")
  private String rechargeKey;
  /**
   * 1-经销商，2-终端，3-消费者
   */
  @ApiModelProperty(name = "参与者标记")
  private String participatorFlag;
}
