package com.biz.crm.cps.business.capital.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 充值信息dto
 *
 * @Author: wjx
 * @Date: 2022/2/17 11:15
 */
@Data
@ApiModel(value = "RechargeDto", description = "充值信息dto")
public class RechargeDto {
  /**
   * 充值类型 税筹充值
   */
  @ApiModelProperty("充值类型")
  private String rechargeKey;

  /**
   * 充值提示编码 (查询充值渠道信息)
   */
  @ApiModelProperty("充值提示编码")
  private String rechargeTipCode;

  /**
   * 充值来源
   */
  @ApiModelProperty("充值来源")
  private String rechargeSource;

  /**
   * 充值时间
   */
  @ApiModelProperty(name = "confirmTime", value = "充值时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date rechargeTime;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 充值账户信息
   */
  @ApiModelProperty("充值账户信息")
  List<RechargeAccountDto> rechargeAccounts;


}
