package com.biz.crm.cps.business.capital.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 充值信息查询dto
 *
 * @Author: wjx
 * @Date: 2022/2/17 11:15
 */
@Data
@ApiModel(value = "RechargeQueryDto", description = "充值信息查询dto")
public class RechargeQueryDto {

  /**
   * 租户编码
   */
  @ApiModelProperty("租户编码")
  private String tenantCode;

  /**
   * 充值编码
   */
  @ApiModelProperty("充值编码")
  private String rechargeCode;

  /**
   * 商户平台用户账户 (通过该编码+商户平台id 可查询税筹平台的账户userAccount)
   */
  @ApiModelProperty("商户平台用户账户")
  private String merchantUserAccount;

  /**
   * 账户编码
   */
  @ApiModelProperty("账户编码")
  private String accountCode;

  /**
   * 账户名称
   */
  @ApiModelProperty("账户名称")
  private String accountName;

  /**
   * 充值状态
   */
  @ApiModelProperty("充值状态")
  private String rechargeStatus;

  /**
   * 审核状态
   */
  @ApiModelProperty("审核状态")
  private String auditStatus;

  /**
   * 确认时间
   */
  @ApiModelProperty(name = "confirmTime", value = "确认时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date confirmTime;

  /**
   * 创建开始时间
   */
  @ApiModelProperty(name = "startCreateTime", value = "创建开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startCreateTime;

  /**
   * 创建结束时间
   */
  @ApiModelProperty(name = "endCreateTime", value = "创建结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endCreateTime;

}
