package com.biz.crm.cps.business.capital.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * cps小程序新增账户充值dto
 * @Author: wjx
 * @Date: 2022/3/29 14:07
 */
@Data
@ApiModel(value = "UserAccountRechargeDto", description = "cps小程序新增账户充值dto")
public class UserAccountRechargeDto {

  /**
   * 充值提示编码 (查询充值渠道信息)
   */
  @ApiModelProperty("充值提示编码")
  private String rechargeTipCode;

  /**
   * 充值来源
   */
  @ApiModelProperty("充值来源")
  private String rechargeSource;

  /**
   * 充值时间
   */
  @ApiModelProperty(name = "confirmTime", value = "充值时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date rechargeTime;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 充值账户编码
   */
  @ApiModelProperty("充值账户编码")
  private String accountCode;

  /**
   * 充值类型 税筹充值
   */
  @ApiModelProperty("充值类型")
  private String rechargeKey;

  /**
   * 商户平台用户账户 (通过该编码+商户平台id 可查询税筹平台的账户userAccount)
   */
  @ApiModelProperty("商户平台用户账户")
  private String merchantUserAccount;

  /**
   * 充值金额
   */
  @ApiModelProperty("充值金额")
  private BigDecimal rechargeAmount;
}
