package com.biz.crm.cps.business.capital.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.capital.sdk.dto.CpsRaiseRechargeAuditDto;
import com.biz.crm.cps.business.capital.sdk.dto.CpsRaiseRechargeDto;
import com.biz.crm.cps.business.capital.sdk.dto.RechargeDto;
import com.biz.crm.cps.business.capital.sdk.dto.RechargeQueryDto;
import com.biz.crm.cps.business.capital.sdk.dto.UserAccountRechargeDto;
import com.biz.crm.cps.business.capital.sdk.vo.CapitalRechargeVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 充值信息(CapitalRecharge)表服务接口
 *
 * @author wjx
 * @since 2022-02-18 16:40:38
 */
public interface CapitalRechargeVoService {

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      查询dto
   * @return
   */
  Page<CapitalRechargeVo> findByConditions(Pageable pageable, RechargeQueryDto dto);

  /**
   * 分页查询当前用户账户的充值信息
   * @param pageable
   * @param dto
   * @return
   */
  Page<CapitalRechargeVo> findCurrentUserByConditions(Pageable pageable, RechargeQueryDto dto);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  CapitalRechargeVo findById(String id);

  /**
   * 新增数据
   *
   * @param rechargeDto 充值信息
   * @return 新增结果
   */
  void create(RechargeDto rechargeDto);

  /**
   * 根据充值编号查询
   * @param rechargeCode
   * @return
   */
  CapitalRechargeVo findByRechargeCode(String rechargeCode);

  /**
   * 根据充值编码更改推送状态
   * @param rechargeCodes
   */
  void updatePushStatusByRechargeCodes(List<String> rechargeCodes);

  /**
   * 根据用户商户平台账号新增数据
   * @param dto
   */
  void createByCurrentUser(UserAccountRechargeDto dto);

  /**
   * 税筹平台充值审核状态同步
   * @param dto
   */
  void updateAuditStatusByAuditDto(CpsRaiseRechargeAuditDto dto);

  /**
   * 批量新增数据(税筹平台用)
   * @param dto
   */
  void createBatch(CpsRaiseRechargeDto dto);
}

