package com.biz.crm.cps.business.capital.sdk.service.observer;

/**
 * 充值挂载接口
 * 税筹充值等模块实现该接口，让充值模块知道系统中已经存在的实现
 * @Author: wjx
 */
public interface RechargeMountRegister {

  /**
   * 充值类型中文名称
   * 税筹充值等实现该方法，告知奖励模板本政策的中文名（注意，具体的充值类型中，设定的该信息不能重复）
   * @return
   */
  String getName();

  /**
   * 充值类型key
   * 具体政策实现该方法，告知协议模板本政策的英文key（注意，具体的充值类型中，设定的该信息不能重复）
   * @return
   */
  String getKey();

  /**
   * 充值类型flag
   * 具体政策实现该方法，告知协议模板本政策的标识数字（注意，具体的充值类型中，设定的该信息不能重复）
   * @return
   */
  String getFlag();

}
