package com.biz.crm.cps.business.capital.sdk.service.observer;

import com.biz.crm.cps.business.capital.sdk.dto.CapitalRechargeInfoDto;
import com.biz.crm.cps.business.capital.sdk.dto.RechargeConditionDto;
import com.biz.crm.cps.business.capital.sdk.vo.CapitalRechargeVo;
import com.biz.crm.cps.business.capital.sdk.vo.RechargeProcessVo;

/**
 * 充值 观察者 由具体提现方式实现 需要提供本方式需要的提现流程
 *
 * @author wjx
 * @date 2022/03/29
 */
public interface RechargeServiceObserver {

  /**
   * 获取充值流程 是否需要认协议 1.判断是否该本模块处理该充值
   *
   * @param rechargeConditionDto
   */
  RechargeProcessVo onRequestRechargeProcess(RechargeConditionDto rechargeConditionDto);

  /**
   * 当所有充值前置条件均满足时 开始充值工作
   * @param capitalRechargeInfoDto
   */
  CapitalRechargeVo onRecharge(CapitalRechargeInfoDto capitalRechargeInfoDto);
}
