package com.biz.crm.cps.business.capital.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 充值信息vo
 *
 * @Author: wjx
 * @Date: 2022/2/21 16:32
 */
@Data
@ApiModel(value = "CapitalRechargeVo", description = "充值信息vo")
public class CapitalRechargeVo extends TenantFlagOpVo {

  /**
   * 充值编码
   */
  @ApiModelProperty("充值编码")
  private String rechargeCode;


  //充值提示信息

  /**
   * 充值提示编码 (查询充值渠道信息)
   */
  @ApiModelProperty("充值提示编码")
  private String rechargeTipCode;

  /**
   * 账户名称
   */
  @ApiModelProperty("充值提示账户名称")
  private String rechargeAccountName;

  /**
   * 开户银行
   */
  @ApiModelProperty("充值提示开户银行")
  private String rechargeAccountBank;

  /**
   * 对公账户
   */
  @ApiModelProperty("充值提示对公账户")
  private String rechargeBankCardNo;


  //充值信息

  /**
   * 商户平台用户账户 (通过该编码+商户平台id 可查询税筹平台的账户userAccount)
   */
  @ApiModelProperty("商户平台用户账户")
  private String merchantUserAccount;

  /**
   * 认证编码
   */
  @ApiModelProperty("认证编码")
  private String customerId;

  /**
   * 充值账户编码
   */
  @ApiModelProperty("充值账户编码")
  private String accountCode;

  /**
   * 账户名称
   */
  @ApiModelProperty("充值账户名称")
  private String accountName;

  /**
   * 充值金额
   */
  @ApiModelProperty("充值金额")
  private BigDecimal rechargeAmount;

  /**
   * 审核状态
   */
  @ApiModelProperty("审核状态")
  private String auditStatus;

  /**
   * 充值状态
   */
  @ApiModelProperty("充值状态")
  private String rechargeStatus;

  /**
   * 充值来源
   */
  @ApiModelProperty("充值来源")
  private String rechargeSource;

  /**
   * 充值时间
   */
  @ApiModelProperty(name = "confirmTime", value = "充值时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date rechargeTime;

  /**
   * 确认时间
   */
  @ApiModelProperty(name = "confirmTime", value = "确认时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date confirmTime;

  /**
   * 企业/个体工商户名称
   */
  @ApiModelProperty("企业/个体工商户名称")
  private String companyName;

  /**
   * 社会信用代码
   */
  @ApiModelProperty("社会信用代码")
  private String socialCreditCode;

  /**
   * 对公账户
   */
  @ApiModelProperty("对公账户")
  private String bankCardNo;

  /**
   * 法人/经营者姓名
   */
  @ApiModelProperty("法人/经营者姓名")
  private String rlegalPersonName;


}
