package com.biz.crm.cps.business.capital.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author wjx
 * @description: 充值流程Vo
 * @date 2021/3/29 下午10:20
 */
@Data
@ApiModel(value = "RechargeProcessVo", description = "充值流程Vo")
public class RechargeProcessVo {

  /**
   * 充值方式flag
   */
  @ApiModelProperty("充值方式flag")
  private String flag;
  /**
   * 充值方式key
   */
  @ApiModelProperty("充值方式key")
  private String key;
  /**
   * 兑现方式name
   */
  @ApiModelProperty("充值方式name")
  private String name;
  /**
   * 兑现方式是否需要显示的签署协议， 系统中约定任何兑现方式都需要签署协议，但是存在是否存在用户感知的签署流程
   */
  @ApiModelProperty("充值方式是否需要显示的签署协议， 系统中约定任何充值方式都需要签署协议，但是存在是否存在用户感知的签署流程")
  private boolean needSign;
  /**
   * 是否需要实名认证
   */
  @ApiModelProperty("是否需要实名认证")
  private boolean needVerify;
  /**
   * 申请证书状态(0：没有申请证书，1：成功申请证书, 2:身份证已被使用，请重新认证, 3：申请证书失败)
   *
   */
  @ApiModelProperty("申请证书状态(0：没有申请证书，1：成功申请证书, 2:身份证已被使用，请重新认证, 3：申请证书失败)")
  private String certStatus;
  /**
   * 实名认证 url
   */
  @ApiModelProperty("实名认证 url")
  private String verifyUrl;
  /**
   * 合同id
   */
  @ApiModelProperty("合同id")
  private String contractId;
  /**
   * 签署url
   */
  @ApiModelProperty("签署url")
  private String contractSignUrl;
  /**
   * 签署合同查看url
   */
  @ApiModelProperty("签署合同查看url")
  private String contractViewUrl;
  /**
   * 企业状态(0:未认证,1:管理员资料已提交,2:企业基本资料已提交,3:已提交待审核,4:审核通过,5:审核不通过,6人工初审通过)
   */
  @ApiModelProperty("企业状态(0:未认证,1:管理员资料已提交,2:企业基本资料已提交,3:已提交待审核,4:审核通过,5:审核不通过,6人工初审通过)")
  private String companyStatus;

  /**
   * 个人状态(0:未激活,1:未认证,2:审核通过,3:已提交待审核,4:审核不通过)
   */
  @ApiModelProperty("个人状态(0:未激活,1:未认证,2:审核通过,3:已提交待审核,4:审核不通过)")
  private String personStatus;

  /**
   * 企业审核不通过原因
   */
  @ApiModelProperty("企业审核不通过原因")
  private String companyAuditFailReason;

  /**
   * 个人审核不通过原因
   */
  @ApiModelProperty("个人审核不通过原因")
  private String personAuditFailReason;
}
