/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.cash.local.service.internal;

import com.biz.crm.cps.business.cash.local.entity.CashConfiguration;
import com.biz.crm.cps.business.cash.local.repository.CashConfigurationRepository;
import com.biz.crm.cps.business.cash.local.service.CashConfigurationService;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="CashConfigurationServiceImpl")
public class CashConfigurationServiceImpl
implements CashConfigurationService {
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private CashConfigurationRepository cashConfigurationRepository;

    @Override
    public CashConfiguration findBySignatoryCodeAndSignatoryType(String signatoryCode, String signatoryType) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{signatoryCode, signatoryType})) {
            return null;
        }
        return this.cashConfigurationRepository.findBySignatoryCodeAndSignatoryType(signatoryCode, signatoryType);
    }

    @Override
    @Transactional
    public CashConfiguration create(CashConfiguration cashConfig) {
        CashConfiguration current = this.createForm(cashConfig);
        this.cashConfigurationRepository.save((Object)current);
        return current;
    }

    private CashConfiguration createForm(CashConfiguration cashConfig) {
        Date now = new Date();
        String account = this.loginUserService.getLoginUser().getAccount();
        cashConfig.setTenantCode(TenantUtils.getTenantCode());
        cashConfig.setCreateAccount(account);
        cashConfig.setCreateTime(now);
        cashConfig.setModifyAccount(account);
        cashConfig.setModifyTime(now);
        cashConfig.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        cashConfig.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.createValidation(cashConfig);
        return cashConfig;
    }

    private void createValidation(CashConfiguration cashConfig) {
        Validate.notNull((Object)((Object)cashConfig), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        cashConfig.setId(null);
        String signatoryCode = cashConfig.getSignatoryCode();
        String signatoryType = cashConfig.getSignatoryType();
        Validate.notBlank((CharSequence)cashConfig.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)signatoryCode, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7b7e\u7ea6\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)signatoryType, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7b7e\u7ea6\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cashConfig.getSignatoryName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7b7e\u7ea6\u8005\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cashConfig.getCashMethodKey(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53d1\u653e\u7c7b\u578b\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cashConfig.getCashMethodName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53d1\u653e\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CashConfiguration old = this.cashConfigurationRepository.findBySignatoryCodeAndSignatoryType(signatoryCode, signatoryType);
        Validate.isTrue((old == null ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7b7e\u7ea6\u8005\u5df2\u5b58\u5728\u5151\u73b0\u670d\u52a1\u5408\u540c", (Object[])new Object[0]);
    }
}

