package com.biz.crm.cps.business.cash.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.cash.local.entity.CashRecord;
import com.biz.crm.cps.business.cash.local.service.CashRecordService;
import com.biz.crm.cps.business.cash.sdk.dto.CashPushDto;
import com.biz.crm.cps.business.cash.sdk.dto.CashRecordDto;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 兑付记录信息http接口
 *
 * @author hecheng
 */
@Api(tags = "兑付记录信息")
@Slf4j
@RestController
@RequestMapping("/v1/cashRecord/cashRecord")
public class CashRecordController {

  @Autowired
  private CashRecordService cashRecordService;

  /**
   * 查询兑现流水的基本信息
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "只是（分页）查询兑现流水的基本信息")
  @GetMapping(value = "/findByConditions")
  public Result<Page<CashRecord>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
          @ApiParam(name = "dto", value = "兑现流水Dto") CashRecordDto dto) {
    try {
      Page<CashRecord> listByPage = cashRecordService.findByConditions(pageable, dto);
      return Result.ok(listByPage);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 兑付推送
   *
   * @param dto 参数dto
   * @return 操作结果
   */
  @ApiOperation(value = "兑付推送")
  @PatchMapping("/send")
  public Result<?> send(@RequestBody @ApiParam(name = "dto", value = "兑付打款Dto") CashPushDto dto) {
    try {
      this.cashRecordService.send(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据id打款（单个或者批量）
   * @param ids
   * @return
   */
  @ApiOperation(value = "根据id打款（单个或者批量）")
  @PatchMapping("/pay")
  public Result<?> pay(@RequestBody @ApiParam(name = "ids", value = "主键集合") List<String> ids) {
    try {
      this.cashRecordService.pay(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
