package com.biz.crm.cps.business.cash.local.controller;

import com.biz.crm.cps.business.cash.sdk.dto.CashRecordPayDto;
import com.biz.crm.cps.business.cash.sdk.service.CashRecordVoService;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 兑付记录信息http接口
 *
 * @author hecheng
 */
@Api(tags = "兑付记录信息")
@Slf4j
@RestController
@RequestMapping("/v1/cashRecord/cashRecord")
public class CashRecordVoController {

  @Autowired
  private CashRecordVoService cashRecordVoService;

  /**
   * 根据付款流水编号更改付款状态 (税筹调用)
   * @param cashRecordPayDto
   * @return
   */
  @ApiOperation(value = "根据付款流水编号更改付款状态")
  @PatchMapping("/updateStatusByCashRecordCode")
  public Result<?> updateStatusByCashRecordCode(@RequestBody @ApiParam(name = "ids", value = "主键集合") CashRecordPayDto cashRecordPayDto) {
    try {
      this.cashRecordVoService.updateStatusByCashRecordCode(cashRecordPayDto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
