package com.biz.crm.cps.business.cash.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @author hecheng
 * @description: 兑付配置
 * @date 2021/8/26 上午10:48
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CashConfiguration", description = "兑付配置")
@TableName("cash_configuration")
public class CashConfiguration extends TenantFlagOpEntity {
  private static final long serialVersionUID = -2746538670193984473L;

  /**
   * 签约者账户编码 指当前登录用户（终端用户、经销商用户、消费者openid）
   *
   * @Column(name = "signatory_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 签约编码 '")
   */
  @ApiModelProperty("签约编码")
  @TableField(value = "signatory_code")
  private String signatoryCode;

  /**
   * 签约者账户名称
   *
   * @Column(name = "signatory_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 签约者名称 '")
   */
  @ApiModelProperty("签约者名称")
  @TableField(value = "signatory_name")
  private String signatoryName;

  /**
   * 签约者类型  终端/经销商 消费者
   *
   * @Column(name = "signatory_type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 签约者类型 '")
   */
  @ApiModelProperty("签约者类型")
  @TableField(value = "signatory_type")
  private String signatoryType;
  /**
   * 兑付类型标志
   *
   * @Column(name = "cash_method_key", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 兑付类型标志 '")
   * <pre>
   * "zhangfangyun":"账房云"
   * "weixinPay", "微信红包"
   * "alipay": "支付宝红包"
   * </pre>
   */
  @ApiModelProperty("兑付类型标志")
  @TableField(value = "cash_method_key")
  private String cashMethodKey;

  /**
   * 兑付类型名称
   *
   * @Column(name = "cash_method_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 兑付类型名称 '")
   * <pre>
   * "zhangfangyun":"账房云"
   * "weixinPay", "微信红包"
   * "alipay": "支付宝红包"
   * </pre>
   */
  @ApiModelProperty("兑付类型名称")
  @TableField(value = "cash_method_name")
  private String cashMethodName;

}
