package com.biz.crm.cps.business.cash.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @author hecheng
 * @description: 兑付流水
 * @date 2021/8/26 上午10:48
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CashRecord", description = "兑付流水")
@TableName("cash_record")
public class CashRecord extends TenantFlagOpEntity {
  private static final long serialVersionUID = -7094463693327845751L;

  /**
   * 兑付流水编码
   *
   * @Column(name = "cash_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 兑付流水编码 '")
   */
  @ApiModelProperty("兑付流水编码")
  @TableField(value = "cash_code")
  private String cashCode;

  /**
   * 兑付类型标志
   *
   * @Column(name = "cash_method_key", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 兑付类型标志 '")
   * <pre>
   * "zhangfangyun":"账房云"
   * "weixinPay", "微信红包"
   * "alipay": "支付宝红包"
   * </pre>
   */
  @ApiModelProperty("兑付类型标志")
  @TableField(value = "cash_method_key")
  private String cashMethodKey;

  /**
   * 兑付类型名称
   *
   * @Column(name = "cash_method_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 兑付类型名称 '")
   * <pre>
   * "zhangfangyun":"账房云"
   * "weixinPay", "微信红包"
   * "alipay": "支付宝红包"
   * </pre>
   */
  @ApiModelProperty("兑付类型名称")
  @TableField(value = "cash_method_name")
  private String cashMethodName;

  /**
   * 所属奖励标志（费用，红包，等等）
   *
   * @Column(name = "reward_key", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 所属奖励方式标志 '")
   */
  @ApiModelProperty("奖励标志（费用，红包，等等）")
  @TableField(value = "reward_key")
  private String rewardKey;

  /**
   * 所属奖励方式名称（费用，红包，等等）
   *
   * @Column(name = "reward_name", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 所属奖励方式名称 '")
   */
  @ApiModelProperty("奖励方式名称（费用，红包，等等）")
  @TableField(value = "reward_name")
  private String rewardName;

  /**
   * 兑付金额
   *
   * @Column(name = "amount", nullable = false, length = 32, columnDefinition = "decimal(10, 2) COMMENT ' 兑付金额 '")
   */
  @ApiModelProperty("兑付金额")
  @TableField(value = "amount")
  private BigDecimal amount;

  /**
   * 兑付状态  CashStatusEnum
   *
   * @Column(name = "cash_status", nullable = false, length = 10, columnDefinition = "VARCHAR(10) COMMENT ' 兑付状态 '")
   */
  @ApiModelProperty("兑付状态")
  @TableField(value = "cash_status")
  private String cashStatus;

  /**
   * 推送状态  CashPushStatusEnum
   *
   * @Column(name = "push_status", nullable = false, length = 10, columnDefinition = "VARCHAR(10) COMMENT ' 推送状态 '")
   */
  @ApiModelProperty("推送状态")
  @TableField(value = "push_status")
  private String pushStatus;

  /**
   * 打款时间
   *
   * @Column(name = "pay_date", nullable = false, columnDefinition = "datetime COMMENT ' 打款时间 '")
   */
  @ApiModelProperty("打款时间")
  @TableField(value = "pay_date")
  private Date payDate;

  /**
   * 推送时间
   *
   * @Column(name = "push_date", nullable = false, columnDefinition = "datetime COMMENT ' 推送时间 '")
   */
  @ApiModelProperty("推送时间")
  @TableField(value = "push_date")
  private Date pushDate;

  /**
   * 到账时间
   *
   * @Column(name = "receive_date", nullable = false, columnDefinition = "datetime COMMENT ' 到账时间 '")
   */
  @ApiModelProperty("到账时间")
  @TableField(value = "receive_date")
  private Date receiveDate;

  /**
   * 收款人编码 （终端用户、经销商用户、消费者openid）
   *
   * @Column(name = "payee_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 收款人编码 '")
   */
  @ApiModelProperty("收款人编码")
  @TableField(value = "payee_code")
  private String payeeCode;

  /**
   * 收款人姓名
   *
   * @Column(name = "payee_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 收款人姓名 '")
   */
  @ApiModelProperty("收款人姓名")
  @TableField(value = "payee_name")
  private String payeeName;

  /**
   * 收款人性别
   *
   * @Column(name = "payee_sex", nullable = true, length = 10, columnDefinition = "VARCHAR(10) COMMENT ' 收款人性别 '")
   */
  @ApiModelProperty("收款人性别")
  @TableField(value = "payee_sex")
  private String payeeSex;

  /**
   * 收款人电话
   *
   * @Column(name = "payee_phone", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 收款人电话 '")
   */
  @ApiModelProperty("收款人电话")
  @TableField(value = "payee_phone")
  private String payeePhone;

  /**
   * 收款人账户 （终端用户、经销商用户、消费者openid）
   *
   * @Column(name = "payee_bank", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 收款人账户 '")
   */
  @ApiModelProperty("收款人账户")
  @TableField(value = "payee_bank")
  private String payeeBank;

  /**
   * 收款人身份证背面
   *
   * @Column(name = "background_idcard_path", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 收款人身份证背面 '")
   */
  @ApiModelProperty("收款人身份证背面")
  @TableField(value = "background_idcard_path")
  private String backgroundIdCardPath;

  /**
   * 收款人身份证正面
   *
   * @Column(name = "headphoto_idcard_path", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 收款人身份证正面 '")
   */
  @ApiModelProperty("收款人身份证正面")
  @TableField(value = "headphoto_idcard_path")
  private String headPhotoIdCardPath;


  /**
   * 参与者编码
   *
   * @Column(name = "participator_code", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT ' 参与者编码 '")
   */
  @ApiModelProperty("客户编码")
  @TableField(value = "participator_code")
  private String participatorCode;

  /**
   * 参与者名称
   *
   * @Column(name = "participator_name", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT ' 参与者名称 '")
   */
  @ApiModelProperty("客户名称")
  @TableField(value = "participator_name")
  private String participatorName;

  /**
   * 参与者类型
   *
   * @Column(name = "participator_type", nullable = false, length = 10, columnDefinition = "varchar(10) COMMENT ' 参与者名称 '")
   */
  @ApiModelProperty("客户类型")
  @TableField(value = "participator_type")
  private String participatorType;

  /**
   * 打款批次号
   *
   * @Column(name = "pay_batch_no", length = 80, columnDefinition = "varchar(80) COMMENT ' 打款批次号 '")
   */
  @ApiModelProperty("打款批次号")
  @TableField(value = "pay_batch_no")
  private String payBatchNo;
}


