package com.biz.crm.cps.business.cash.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.cash.local.entity.CashRecord;
import com.biz.crm.cps.business.cash.sdk.dto.CashRecordDto;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 兑付记录
 *
 * @author hecheng
 * @date 2021/08/26
 */
public interface CashRecordMapper extends BaseMapper<CashRecord> {

  /**
   * 分页条件查询
   *
   * @param page
   * @param dto
   * @return
   */
  Page<CashRecord> findByConditions(Page<CashRecord> page, @Param("dto") CashRecordDto dto);

  /**
   * 根据参与者信息和时间范围统计金额
   * @param participatorCode 参与者编码
   * @param participatorFlag 参与者标识
   * @param startTime 开始时间
   * @param endTime 结束时间
   * @return
   */
  BigDecimal findAmountByParticipatorAndDateTime(@Param("participatorCode") String participatorCode, @Param("participatorFlag") String participatorFlag, @Param("startTime") Date startTime, @Param("endTime") Date endTime);

  /**
   * 根据参与者信息和时间范围统计次数
   * @param participatorCode 参与者编码
   * @param participatorFlag 参与者标识
   * @param startTime 开始时间
   * @param endTime 结束时间
   * @return
   */
  Integer findCountByParticipatorAndDateTime(@Param("participatorCode") String participatorCode, @Param("participatorFlag") String participatorFlag, @Param("startTime") Date startTime, @Param("endTime") Date endTime);
}
