package com.biz.crm.cps.business.cash.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.cash.local.entity.CashConfiguration;
import com.biz.crm.cps.business.cash.local.mapper.CashConfigurationMapper;
import org.springframework.stereotype.Component;

/**
 * 兑付配置信息 的 数据库访问类 {@link CashConfiguration}
 *
 * @author hecheng
 */
@Component
public class CashConfigurationRepository extends ServiceImpl<CashConfigurationMapper, CashConfiguration> {

  /**
   * 按签署账户code，签署账类型,奖励方式查询 兑付配置
   *
   * @param signatoryCode
   * @param signatoryType
   * @return
   */
  public CashConfiguration findBySignatoryCodeAndSignatoryType(String signatoryCode, String signatoryType) {
    return this.lambdaQuery().eq(CashConfiguration::getSignatoryCode, signatoryCode).eq(CashConfiguration::getSignatoryType, signatoryType).one();
  }
}
