package com.biz.crm.cps.business.cash.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.cash.local.entity.CashRecord;
import com.biz.crm.cps.business.cash.local.mapper.CashRecordMapper;
import com.biz.crm.cps.business.cash.sdk.dto.CashRecordDto;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 兑付配置信息 的 数据库访问类 {@link CashRecord}
 *
 * @author hecheng
 */
@Component
public class CashRecordRepository extends ServiceImpl<CashRecordMapper, CashRecord> {

  /**
   * 分页按条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<CashRecord> findByConditions(Pageable pageable, CashRecordDto dto) {
    Page<CashRecord> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<CashRecord> selectPage = this.baseMapper.findByConditions(page, dto);
    return selectPage;
  }

  /**
   * 更新兑付状态
   *
   * @param cashRecord
   */
  public void updateCashStatus(CashRecord cashRecord) {
    this.lambdaUpdate().eq(CashRecord::getCashCode, cashRecord.getCashCode())
            .set(CashRecord::getCashStatus, cashRecord.getCashStatus())
            .set(CashRecord::getRemark, cashRecord.getRemark()).update();
  }

  /**
   * 根据id批量修改（单个或者批量）
   * @param ids
   * @param cashStatus
   */
  public void updateCashStatusByIds(List<String> ids, String cashStatus) {
    this.lambdaUpdate().set(CashRecord::getPayDate, new Date()).set(CashRecord::getCashStatus, cashStatus).in(CashRecord::getId, ids).update();
  }

  /**
   * 根据参与者信息和时间范围统计金额
   * @param participatorCode 参与者编码
   * @param participatorFlag 参与者标识
   * @param startTime 开始时间
   * @param endTime 结束时间
   * @return
   */
  public BigDecimal findAmountByParticipatorAndDateTime(String participatorCode, String participatorFlag, Date startTime, Date endTime) {
    return this.baseMapper.findAmountByParticipatorAndDateTime(participatorCode, participatorFlag, startTime, endTime);
  }

  /**
   * 根据参与者信息和时间范围统计次数
   * @param participatorCode 参与者编码
   * @param participatorFlag 参与者标识
   * @param startTime 开始时间
   * @param endTime 结束时间
   * @return
   */
  public Integer findCountByParticipatorAndDateTime(String participatorCode, String participatorFlag, Date startTime, Date endTime) {
    return this.baseMapper.findCountByParticipatorAndDateTime(participatorCode, participatorFlag, startTime, endTime);
  }

  /**
   * 根据兑付流水号修改状态
   * @param cashCode
   * @param cashStatus
   */
  public void updateCashStatusByCashCode(String cashCode, String cashStatus) {
    this.lambdaUpdate().set(CashRecord::getPayDate, new Date()).set(CashRecord::getCashStatus, cashStatus).eq(CashRecord::getCashCode, cashCode).update();
  }
}
