package com.biz.crm.cps.business.cash.local.service;

import com.biz.crm.cps.business.cash.local.entity.CashConfiguration;

/**
 * @author hecheng
 * @description: 兑付配置service
 */
public interface CashConfigurationService {

  /**
   * 按签署账户code，签署账类型,奖励方式查询 兑付配置
   *
   * @param signatoryCode
   * @param signatoryType
   * @return
   */
  CashConfiguration findBySignatoryCodeAndSignatoryType(String signatoryCode, String signatoryType);

  /**
   * 创建兑付配置 可以由实际完成兑付目标的一方调用生成 例如终端是账房云发放，则由账房云完成法大大签署合同完成后调用本方法 也可以是默认兑付方式生成，例如终端是微信提现时直接生成兑付配置
   *
   * @param cashConfig
   * @return
   */
  CashConfiguration create(CashConfiguration cashConfig);
}
