package com.biz.crm.cps.business.cash.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.cash.local.entity.CashRecord;
import com.biz.crm.cps.business.cash.sdk.dto.CashPushDto;
import com.biz.crm.cps.business.cash.sdk.dto.CashRecordDto;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author hecheng
 * @description: 兑付流水service
 */
public interface CashRecordService {

  /**
   * 创建兑付流水
   *
   * @param cashRecord
   * @return
   */
  CashRecord create(CashRecord cashRecord);

  /**
   * 分页查询兑现流水
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<CashRecord> findByConditions(Pageable pageable, CashRecordDto dto);

  /**
   * 更新兑付状态
   * @param cashRecord
   */
  void updateCashStatus(CashRecord cashRecord);

  /**
   * 兑付推送
   *
   * @param dto 参数dto
   */
  void send(CashPushDto dto);

  /**
   * 根据id打款（单个或者批量）
   * @param ids
   */
  void pay(List<String> ids);

  /**
   * 根据参与者信息和时间范围统计金额
   * @param participatorCode 参与者编码
   * @param participatorFlag 参与者标识
   * @param startTime 开始时间
   * @param endTime 结束时间
   * @return
   */
  BigDecimal findAmountByParticipatorAndDateTime(String participatorCode, String participatorFlag, Date startTime, Date endTime);

  /**
   * 根据参与者信息和时间范围统计次数
   * @param participatorCode 参与者编码
   * @param participatorFlag 参与者标识
   * @param startTime 开始时间
   * @param endTime 结束时间
   * @return
   */
  Integer findCountByParticipatorAndDateTime(String participatorCode, String participatorFlag, Date startTime, Date endTime);
}
