package com.biz.crm.cps.business.cash.local.service.internal;

import com.biz.crm.cps.business.cash.local.entity.CashConfiguration;
import com.biz.crm.cps.business.cash.local.service.CashConfigurationService;
import com.biz.crm.cps.business.cash.sdk.dto.CashConfigurationDto;
import com.biz.crm.cps.business.cash.sdk.service.CashConfigurationVoService;
import com.biz.crm.cps.business.cash.sdk.vo.CashConfigurationVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;

/**
 * @author hecheng
 * @description: 兑现配置记录Voservice
 * @date 2021/9/1 下午4:41
 */
@Service("CashConfigurationVoServiceImpl")
public class CashConfigurationVoServiceImpl implements CashConfigurationVoService {

  @Autowired
  private CashConfigurationService cashConfigurationService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public CashConfigurationVo findBySignatoryCodeAndSignatoryType(String signatoryCode, String signatoryType) {
    if (StringUtils.isAnyBlank(signatoryCode,signatoryType)) {
      return null;
    }
    CashConfiguration cashConfiguration = this.cashConfigurationService.findBySignatoryCodeAndSignatoryType(signatoryCode, signatoryType);
    if (Objects.isNull(cashConfiguration)) {
      return null;
    }
    CashConfigurationVo cashConfigurationVo = this.nebulaToolkitService.copyObjectByWhiteList(cashConfiguration, CashConfigurationVo.class, HashSet.class, ArrayList.class);
    return cashConfigurationVo;
  }

  @Override
  @Transactional
  public CashConfigurationVo create(CashConfigurationDto cashConfigurationDto) {
    Validate.notNull(cashConfigurationDto, "兑付记录不能为空");
    CashConfiguration cashConfiguration = this.nebulaToolkitService.copyObjectByWhiteList(cashConfigurationDto, CashConfiguration.class, HashSet.class, ArrayList.class);
    cashConfiguration = this.cashConfigurationService.create(cashConfiguration);
    CashConfigurationVo cashConfigurationVo = this.nebulaToolkitService.copyObjectByWhiteList(cashConfiguration, CashConfigurationVo.class, HashSet.class, ArrayList.class);
    return cashConfigurationVo;
  }

}
