package com.biz.crm.cps.business.cash.local.service.internal;

import com.biz.crm.cps.business.cash.local.entity.CashRecord;
import com.biz.crm.cps.business.cash.local.repository.CashRecordRepository;
import com.biz.crm.cps.business.cash.local.service.CashRecordService;
import com.biz.crm.cps.business.cash.sdk.common.enums.CashStatusEnum;
import com.biz.crm.cps.business.cash.sdk.dto.CashRecordDto;
import com.biz.crm.cps.business.cash.sdk.dto.CashRecordPayDto;
import com.biz.crm.cps.business.cash.sdk.service.CashRecordVoService;
import com.biz.crm.cps.business.cash.sdk.vo.CashRecordVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;

/**
 * @author hecheng
 * @description: 提现记录Voservice
 * @date 2021/8/31 下午7:31
 */
@Service("CashRecordVoServiceImpl")
public class CashRecordVoServiceImpl implements CashRecordVoService {

  @Autowired
  private CashRecordService cashRecordService;
  @Autowired
 private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private CashRecordRepository cashRecordRepository;

  @Override
  @Transactional
  public CashRecordVo create(CashRecordDto cashRecordDto) {
    Validate.notNull(cashRecordDto, "兑付记录不能为空");
    CashRecord cashRecord = this.nebulaToolkitService.copyObjectByWhiteList(cashRecordDto, CashRecord.class, HashSet.class, ArrayList.class);
    cashRecord = this.cashRecordService.create(cashRecord);
    CashRecordVo cashRecordVo = this.nebulaToolkitService.copyObjectByWhiteList(cashRecord, CashRecordVo.class, HashSet.class, ArrayList.class);
    return cashRecordVo;
  }

  @Override
  @Transactional
  public void updateCashStatus(CashRecordDto cashRecordDto) {
    Validate.notBlank(cashRecordDto.getCashCode(), "兑付编码不能为空");
    Validate.notBlank(cashRecordDto.getCashStatus(), "兑付状态不能为空");
    Validate.notBlank(cashRecordDto.getRemark(), "兑付备注不能为空");
    CashRecord cashRecord = this.nebulaToolkitService.copyObjectByWhiteList(cashRecordDto, CashRecord.class, HashSet.class, ArrayList.class);
    this.cashRecordService.updateCashStatus(cashRecord);
  }

  @Override
  public void updateStatusByCashRecordCode(CashRecordPayDto cashRecordPayDto) {
    Validate.notNull(cashRecordPayDto,"据付款流水编号更改付款记录状态时,请求数据不能为空");
    Validate.notBlank(cashRecordPayDto.getCashCode(),"据付款流水编号更改付款记录状态时,付款流水编号不能为空");
    this.cashRecordRepository.updateCashStatusByCashCode(cashRecordPayDto.getCashCode(), CashStatusEnum.PAID.getDictCode());
  }
}
