package com.biz.crm.cps.business.cash.local.service.notifier;

import com.biz.crm.cps.business.cash.local.service.CashRecordService;
import com.biz.crm.cps.business.reward.sdk.event.RequestCashListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 请求奖励监听事件实现类
 * @author songjingen
 */
@Component
public class CashRequestCashListener implements RequestCashListener {

  @Autowired
  private CashRecordService cashRecordService;

  @Override
  public BigDecimal onRequestAmountByParticipatorAndDateTime(String participatorCode, String participatorFlag, Date startTime, Date endTime) {
    BigDecimal bigDecimal = this.cashRecordService.findAmountByParticipatorAndDateTime(participatorCode, participatorFlag, startTime, endTime);
    return bigDecimal;
  }

  @Override
  public Integer onRequestCountByParticipatorAndDateTime(String participatorCode, String participatorFlag, Date startTime, Date endTime) {
    Integer integer = this.cashRecordService.findCountByParticipatorAndDateTime(participatorCode, participatorFlag, startTime, endTime);
    return integer;
  }
}
