package com.biz.crm.cps.business.cash.local.service.observer;

import com.biz.crm.cps.business.cash.sdk.dto.CashConditionDto;
import com.biz.crm.cps.business.cash.sdk.service.CashConfigurationVoService;
import com.biz.crm.cps.business.cash.sdk.service.observer.CashServiceObserver;
import com.biz.crm.cps.business.cash.sdk.vo.CashConfigurationVo;
import com.biz.crm.cps.business.cash.sdk.vo.CashProcessVo;
import com.biz.crm.cps.business.cash.sdk.vo.CashRecordVo;
import com.biz.crm.cps.business.reward.sdk.dto.RewardCashConditionDto;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardCashObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardCashProcessVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardCashRecordVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @author hecheng
 * @description: 奖励兑现观察者实现
 * @date 2021/8/27 下午10:38
 */
@Service("RewardCashObserverImpl")
public class RewardCashObserverImpl implements RewardCashObserver {

  @Autowired(required = false)
  private List<CashServiceObserver> cashServiceObservers;
  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private CashConfigurationVoService cashConfigurationVoService;

  @Override
  public RewardCashProcessVo onRequestCashProcess(RewardCashConditionDto condition) {
    /**
     * 1.查询本兑现账户是否已有兑现配置，
     * 1。1如果已有说明兑付的方式前置条件已完成过不用再次进行
     * 1。2如果没有那么加载系统默认配置作为初次设置
     */
    if (CollectionUtils.isEmpty(this.cashServiceObservers) || Objects.isNull(condition)) {
      return null;
    }
    CashConditionDto cashConditionDto = this.nebulaToolkitService.copyObjectByBlankList(condition, CashConditionDto.class, HashSet.class, ArrayList.class);
    CashConfigurationVo config = cashConfigurationVoService.findBySignatoryCodeAndSignatoryType(condition.getPayeeCode(), condition.getParticipatorFlag());
    RewardCashProcessVo rewardCashProcessVo = null;
    if (Objects.nonNull(config)) {
      rewardCashProcessVo = new RewardCashProcessVo();
      rewardCashProcessVo.setKey(config.getCashMethodKey());
      rewardCashProcessVo.setName(config.getCashMethodName());
      rewardCashProcessVo.setNeedSign(false);
      rewardCashProcessVo.setNeedVerify(false);
      return rewardCashProcessVo;
    }

    for (CashServiceObserver cashServiceObserver : this.cashServiceObservers) {
      //通知观察者们 如果是自己负责兑付 那么可以开始工作了 理论上只会有一种符合的方式
      CashProcessVo cashProcessVo = cashServiceObserver.onRequestCashProcess(cashConditionDto);
      if (Objects.nonNull(cashProcessVo)) {
        rewardCashProcessVo = this.nebulaToolkitService.copyObjectByBlankList(cashProcessVo, RewardCashProcessVo.class, HashSet.class, ArrayList.class);
        return rewardCashProcessVo;
      }
    }
    return null;
  }

  @Override
  public RewardCashRecordVo onCash(RewardCashConditionDto condition) {
    if (CollectionUtils.isEmpty(this.cashServiceObservers) || Objects.isNull(condition)) {
      return null;
    }
    for (CashServiceObserver cashServiceObserver : this.cashServiceObservers) {
      //通知观察者们 如果是自己负责兑付 那么可以开始工作了
      CashConditionDto cashCondition = this.nebulaToolkitService.copyObjectByBlankList(condition, CashConditionDto.class, HashSet.class, ArrayList.class);
      CashRecordVo cashRecordVo = cashServiceObserver.onCash(cashCondition);
      if (cashRecordVo != null) {
        RewardCashRecordVo rewardCashRecordVo = this.nebulaToolkitService.copyObjectByBlankList(cashRecordVo, RewardCashRecordVo.class, HashSet.class, ArrayList.class);
        return rewardCashRecordVo;
      }
    }
    return null;
  }
}
