/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.cash.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.cash.local.entity.CashRecord;
import com.biz.crm.cps.business.cash.local.repository.CashRecordRepository;
import com.biz.crm.cps.business.cash.local.service.CashRecordService;
import com.biz.crm.cps.business.cash.sdk.common.enums.CashStatusEnum;
import com.biz.crm.cps.business.cash.sdk.dto.CashRecordDto;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="CashRecordServiceImpl")
public class CashRecordServiceImpl
implements CashRecordService {
    @Autowired
    private CashRecordRepository cashRecordRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    @Override
    @Transactional
    public CashRecord create(CashRecord cashRecord) {
        CashRecord current = this.createForm(cashRecord);
        this.cashRecordRepository.save((Object)current);
        return current;
    }

    @Override
    public Page<CashRecord> findByConditions(Pageable pageable, CashRecordDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new CashRecordDto();
        }
        return this.cashRecordRepository.findByConditions(pageable, dto);
    }

    @Override
    @Transactional
    public void updateCashStatus(CashRecord cashRecord) {
        Validate.notNull((Object)((Object)cashRecord), (String)"\u5151\u4ed8\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cashRecord.getCashCode(), (String)"\u5151\u4ed8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cashRecord.getCashStatus(), (String)"\u5151\u4ed8\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cashRecord.getRemark(), (String)"\u5151\u4ed8\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.cashRecordRepository.updateCashStatus(cashRecord);
    }

    private CashRecord createForm(CashRecord cashRecord) {
        Date now = new Date();
        if (Objects.nonNull(this.generateCodeService)) {
            cashRecord.setCashCode((String)this.generateCodeService.generateCode("cash_record_code", 1).get(0));
        }
        String account = this.loginUserService.getLoginAccountName();
        cashRecord.setTenantCode(TenantUtils.getTenantCode());
        cashRecord.setCreateAccount(account);
        cashRecord.setCreateTime(now);
        cashRecord.setModifyAccount(account);
        cashRecord.setModifyTime(now);
        cashRecord.setPayDate(new Date());
        cashRecord.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        cashRecord.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.createValidation(cashRecord);
        if (StringUtils.isBlank((CharSequence)cashRecord.getCashStatus())) {
            cashRecord.setCashStatus(CashStatusEnum.NO_PAID.getDictCode());
        }
        return cashRecord;
    }

    private void createValidation(CashRecord cashRecord) {
        Validate.notNull((Object)((Object)cashRecord), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        cashRecord.setId(null);
        Validate.notBlank((CharSequence)cashRecord.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cashRecord.getCashCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5151\u73b0\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cashRecord.getCashMethodKey(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5151\u73b0\u65b9\u5f0f\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cashRecord.getCashMethodName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5151\u73b0\u65b9\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cashRecord.getRewardKey(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5151\u73b0\u5956\u52b1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cashRecord.getRewardName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5151\u73b0\u5956\u52b1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)cashRecord.getAmount(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5151\u73b0\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)cashRecord.getPayDate(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5151\u73b0\u6253\u6b3e\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cashRecord.getParticipatorType(), (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cashRecord.getParticipatorCode(), (String)"\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cashRecord.getParticipatorName(), (String)"\u53c2\u4e0e\u8005\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.isTrue((cashRecord.getPayeeName() == null || cashRecord.getPayeeName().length() < 64 ? 1 : 0) != 0, (String)"\u6536\u6b3e\u4eba\u59d3\u540d\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((cashRecord.getPayeeSex() == null || cashRecord.getPayeeSex().length() < 10 ? 1 : 0) != 0, (String)"\u6536\u6b3e\u4eba\u6027\u522b\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(10)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((cashRecord.getPayeePhone() == null || cashRecord.getPayeePhone().length() < 12 ? 1 : 0) != 0, (String)"\u6536\u6b3e\u4eba\u7535\u8bdd\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(11)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((cashRecord.getPayeeBank() == null || cashRecord.getPayeeBank().length() < 64 ? 1 : 0) != 0, (String)"\u6536\u6b3e\u4eba\u8d26\u6237\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((cashRecord.getBackgroundIdCardPath() == null || cashRecord.getBackgroundIdCardPath().length() < 255 ? 1 : 0) != 0, (String)"\u6536\u6b3e\u4eba\u8eab\u4efd\u8bc1\u6b63\u9762\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((cashRecord.getHeadPhotoIdCardPath() == null || cashRecord.getHeadPhotoIdCardPath().length() < 255 ? 1 : 0) != 0, (String)"\u6536\u6b3e\u4eba\u8eab\u4efd\u8bc1\u80cc\u9762\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((cashRecord.getParticipatorType().length() < 64 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((cashRecord.getParticipatorCode().length() < 64 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((cashRecord.getParticipatorName().length() < 64 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

