/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.cash.local.service.observer;

import com.biz.crm.cps.business.cash.sdk.dto.CashConditionDto;
import com.biz.crm.cps.business.cash.sdk.service.CashConfigurationVoService;
import com.biz.crm.cps.business.cash.sdk.service.observer.CashServiceObserver;
import com.biz.crm.cps.business.cash.sdk.vo.CashConfigurationVo;
import com.biz.crm.cps.business.cash.sdk.vo.CashProcessVo;
import com.biz.crm.cps.business.cash.sdk.vo.CashRecordVo;
import com.biz.crm.cps.business.common.sdk.enums.MessageTypeEnum;
import com.biz.crm.cps.business.common.sdk.event.BusinessMessageEvent;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.reward.sdk.dto.RewardCashConditionDto;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardCashObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardCashProcessVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardCashRecordVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="RewardCashObserverImpl")
public class RewardCashObserverImpl
implements RewardCashObserver {
    private static final Logger log = LoggerFactory.getLogger(RewardCashObserverImpl.class);
    @Autowired(required=false)
    private List<CashServiceObserver> cashServiceObservers;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private CashConfigurationVoService cashConfigurationVoService;
    @Autowired
    private LoginUserService userService;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Value(value="${url.redPackage:}")
    private String url;

    public RewardCashProcessVo onRequestCashProcess(RewardCashConditionDto condition) {
        if (CollectionUtils.isEmpty(this.cashServiceObservers) || Objects.isNull(condition)) {
            return null;
        }
        CashConditionDto cashConditionDto = (CashConditionDto)this.nebulaToolkitService.copyObjectByBlankList((Object)condition, CashConditionDto.class, HashSet.class, ArrayList.class, new String[0]);
        CashConfigurationVo config = this.cashConfigurationVoService.findBySignatoryCodeAndSignatoryType(condition.getPayeeCode(), condition.getParticipatorFlag());
        RewardCashProcessVo rewardCashProcessVo = null;
        if (Objects.nonNull(config)) {
            rewardCashProcessVo = new RewardCashProcessVo();
            rewardCashProcessVo.setKey(config.getCashMethodKey());
            rewardCashProcessVo.setName(config.getCashMethodName());
            rewardCashProcessVo.setNeedSign(false);
            rewardCashProcessVo.setNeedVerify(false);
            return rewardCashProcessVo;
        }
        for (CashServiceObserver cashServiceObserver : this.cashServiceObservers) {
            CashProcessVo cashProcessVo = cashServiceObserver.onRequestCashProcess(cashConditionDto);
            if (!Objects.nonNull(cashProcessVo)) continue;
            rewardCashProcessVo = (RewardCashProcessVo)this.nebulaToolkitService.copyObjectByBlankList((Object)cashProcessVo, RewardCashProcessVo.class, HashSet.class, ArrayList.class, new String[0]);
            return rewardCashProcessVo;
        }
        return null;
    }

    public RewardCashRecordVo onCash(RewardCashConditionDto condition) {
        if (CollectionUtils.isEmpty(this.cashServiceObservers) || Objects.isNull(condition)) {
            return null;
        }
        for (CashServiceObserver cashServiceObserver : this.cashServiceObservers) {
            CashConditionDto cashCondition;
            CashRecordVo cashRecordVo = cashServiceObserver.onCash(cashCondition = (CashConditionDto)this.nebulaToolkitService.copyObjectByBlankList((Object)condition, CashConditionDto.class, HashSet.class, ArrayList.class, new String[0]));
            if (cashRecordVo == null) continue;
            RewardCashRecordVo rewardCashRecordVo = (RewardCashRecordVo)this.nebulaToolkitService.copyObjectByBlankList((Object)cashRecordVo, RewardCashRecordVo.class, HashSet.class, ArrayList.class, new String[0]);
            BusinessMessageEvent event = new BusinessMessageEvent();
            event.setTitle("\u7ea2\u5305\u63d0\u73b0\u5230\u8d26\u5566");
            event.setCode(this.url + this.userService.getLoginAccountName());
            event.setContent(cashCondition.getParticipatorName() + "\u63d0\u73b0" + cashCondition.getAmount() + "\u5143");
            event.setType(MessageTypeEnum.RED_PACKET.getCode());
            event.setOwner(cashCondition.getParticipatorCode());
            event.setPushDate(Long.valueOf(System.currentTimeMillis()));
            this.rocketMQTemplate.syncSendOrderly("MESSAGE_TOPIC", MessageBuilder.withPayload((Object)event).build(), "MESSAGE_GROUP");
            return rewardCashRecordVo;
        }
        return null;
    }
}

