package com.biz.crm.cps.business.cash.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Description:兑现状态类型
 * @Author: hecheng
 **/
public enum CashStatusEnum {
  /**
   * 已打款
   */
  PAID("paid", "1", "已打款", "1"),
  /**
   * 未打款
   */
  NO_PAID("nopaid", "2", "未打款", "2"),
  /**
   * 打款中
   */
  PAIDING("paiding", "3", "打款中", "3"),
  /**
   * 打款失败
   */
  PAID_FAIL("paidfail", "4", "打款失败", "4");

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  CashStatusEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 CashStatusEnum
   *
   * @param key
   * @return
   */
  public static CashStatusEnum getByKey(String key) {
    return Arrays.stream(CashStatusEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }
}
