package com.biz.crm.cps.business.cash.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Description:发放合同类型
 * @Author: hecheng
 **/
public enum WithdrawContractTypeEnum {
  /**
   * 账房云
   */
  ZHANGFANGYUN("zhangfangyun","zhangfangyun", "账房云","1"),
  /**
   * 微信红包
   */
  WEIXIN_PAY("weixinPay","weixinPay", "微信红包","2"),
  /**
   * 支付宝红包
   */
  ALIPAY("alipay","alipay", "支付宝红包","3"),;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  WithdrawContractTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 WithdrawContractTypeEnum
   *
   * @param key
   * @return
   */
  public static WithdrawContractTypeEnum getByKey(String key) {
    return Arrays.stream(WithdrawContractTypeEnum.values()).filter(item ->Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }
}
