package com.biz.crm.cps.business.cash.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;

/**
 * @ClassName: CashConditionDto
 * @Author: hecheng
 * @Description: 兑付条件Dto
 */
@Data
@ApiModel(value = "CashConditionDto", description = "兑付条件Dto")
public class CashConditionDto {

  /**
   * 提现金额
   */
  @ApiModelProperty("提现金额")
  private BigDecimal amount;
  /**
   * 参与者编码 经销商/终端/ 编码   消费者openid
   */
  @ApiModelProperty("参与者编码）")
  private String participatorCode;
  /**
   * 参与者编码 经销商/终端/消费者 名称
   */
  @ApiModelProperty("参与者名称）")
  private String participatorName;

  /**
   * ParticipatorTypeEnum 参与者标记（实际扫码者） 1-经销商，2-终端，3-消费者
   */
  @ApiModelProperty("参与者标记")
  private String participatorFlag;
  /**
   * 提现时必传 微信 或者第三方提现时的外部id
   */
  @ApiModelProperty(name = "openId", required = true)
  private String openId;
  /**
   * 收款人编码 （终端用户、经销商用户、消费者openid）
   */
  @ApiModelProperty("收款人编码")
  private String payeeCode;

  /**
   * 收款人姓名 参与者标记为终端和经销商时 这个值由当前登录用户中获取，消费者为微信昵称
   */
  @ApiModelProperty("收款人姓名")
  private String payeeName;
  /**
   * 收款人电话 参与者标记为终端和经销商时 这个值由当前登录用户中获取，消费者为微信昵称
   */
  @ApiModelProperty("收款人电话")
  private String payeePhone;
  /**
   * 兑付类型 微信，支付宝
   */
  @ApiModelProperty("兑付类型")
  private String cashKey;
  /**
   * 奖励方式
   */
  @ApiModelProperty("奖励方式")
  private String rewardKey;
  /**
   * 奖励方式
   */
  @ApiModelProperty("奖励方式")
  private String rewardName;
}
