package com.biz.crm.cps.business.cash.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author hecheng
 * @description: 兑付流水Vo
 * @date 2021/8/31 下午4:41
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CashRecordVo", description = "兑付流水Vo")
public class CashRecordVo extends TenantFlagOpVo {
  private static final long serialVersionUID = -4311733494004765202L;

  /**
   * 兑付流水编码
   */
  @ApiModelProperty("兑付流水编码")
  private String cashCode;

  /**
   * 兑付类型标志
   *
   * <pre>
   * "zhangfangyun":"账房云"
   * "weixinPay", "微信红包"
   * "alipay": "支付宝红包"
   * </pre>
   */
  @ApiModelProperty("兑付类型标志")
  private String cashMethodKey;

  /**
   * 兑付类型名称
   *
   * <pre>
   * "zhangfangyun":"账房云"
   * "weixinPay", "微信红包"
   * "alipay": "支付宝红包"
   * </pre>
   */
  @ApiModelProperty("兑付类型名称")
  private String cashMethodName;

  /**
   * 所属奖励标志（费用，红包，等等）
   */
  @ApiModelProperty("奖励标志（费用，红包，等等）")
  private String rewardKey;

  /**
   * 所属奖励方式名称（费用，红包，等等）
   */
  @ApiModelProperty("奖励方式名称（费用，红包，等等）")
  private String rewardName;

  /**
   * 兑付金额
   */
  @ApiModelProperty("兑付金额")
  private BigDecimal amount;

  /**
   * 兑付状态
   */
  @ApiModelProperty("兑付状态")
  private String cashStatus;
  /**
   * 打款时间
   */
  @ApiModelProperty("打款时间")
  private Date payDate;

  /**
   * 到账时间
   */
  @ApiModelProperty("到账时间")
  private Date receiveDate;

  /**
   * 收款人编码 （终端用户、经销商用户、消费者openid）
   */
  @ApiModelProperty("收款人编码")
  private String payeeCode;

  /**
   * 收款人姓名
   */
  @ApiModelProperty("收款人姓名")
  private String payeeName;

  /**
   * 收款人性别
   */
  @ApiModelProperty("收款人性别")
  private String payeeSex;

  /**
   * 收款人电话
   */
  @ApiModelProperty("收款人电话")
  private String payeePhone;

  /**
   * 收款人账户 （终端用户、经销商用户、消费者openid）
   */
  @ApiModelProperty("收款人账户")
  private String payeeBank;
  /**
   * 收款人身份证背面
   */
  @ApiModelProperty("收款人身份证背面")

  private String backgroundIdCardPath;

  /**
   * 收款人身份证正面
   */
  @ApiModelProperty("收款人身份证正面")
  private String headPhotoIdCardPath;

  /**
   * 参与者编码
   */
  @ApiModelProperty("客户编码")
  private String participatorCode;

  /**
   * 参与者名称
   */
  @ApiModelProperty("客户名称")
  private String participatorName;

  /**
   * 参与者类型
   */
  @ApiModelProperty("客户类型")
  private String participatorType;

}
