package com.biz.crm.cps.business.common.local.notifier;

import com.biz.crm.cps.business.common.local.vo.SimpleTenantInfo;
import com.bizunited.nebula.common.event.RequestTenantInfoEventListener;
import com.bizunited.nebula.common.vo.AbstractTenantInfo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Component;


/**
 * 按照下层基础设施-nebula——tenant组件的要求，
 * 本经典登录模块需要实现TenantRequestEventListener事件监听，以便告知nebula——tenant组件如何找到系统的tenantCode信息
 * 以及如何组装tencodeInfo信息
 * @author hefan
 */
@Component
public class TenantRequestEventListenerForSecurity implements RequestTenantInfoEventListener {

  @Override
  public AbstractTenantInfo onBuildTenantInfo(HttpServletRequest request, HttpServletResponse response) {
    // 为什么这里默认的的SimpleTenantInfo不需要设置租户信息，可参见SimpleTenantInfo类的源代码
    SimpleTenantInfo simpleTenantInfo = new SimpleTenantInfo();
    return simpleTenantInfo;
  }

  @Override
  public boolean shouldNotTenantInfoFilter(HttpServletRequest request) {
    return true;
  }

  @Override
  public boolean shouldNotAppFilter(HttpServletRequest request) {
    return true;
  }
}