package com.biz.crm.cps.business.common.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description: 是否
 * @author: rentao
 * @date: 2021/12/21 16:17
 */
public enum YesNoCodeEnum {

  NO(false,"0" ,"否","1"),
  YES(true, "1","是","2");

  private Boolean key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  YesNoCodeEnum(Boolean key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public Boolean getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }
  /**
   * 通过key获取 YesNoCodeEnum
   *
   * @param key
   * @return
   */
  public static YesNoCodeEnum getByKey(String key) {
    return Arrays
        .stream(YesNoCodeEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
        .findFirst().orElse(null);
  }
  /**
   * 通过dictCode获取 YesNoCodeEnum
   *
   * @param dictCode
   * @return
   */
  public static YesNoCodeEnum getByDictCode(String dictCode) {
    return Arrays.stream(YesNoCodeEnum.values()).filter(item -> Objects.equals(item.getDictCode(), dictCode))
        .findFirst().orElse(null);
  }

}
