package com.biz.crm.cps.business.consumer.local.entity;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

/**
 * 分利消费者信息
 * @author songjingen
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "Consumer", description = "分利消费者信息")
@TableName("consumer")
public class Consumer extends TenantOpEntity {
  private static final long serialVersionUID = 5996597929054751388L;

  /**
   * 消费者编码
   *   @Column(name = "consumer_code",nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 消费者编码 '")
   */
  @ApiModelProperty("消费者编码")
  @TableField(value = "consumer_code")
  private String consumerCode;

  /**
   * 消费者外部id
   *   @Column(name = "external_id",nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 消费者外部id '")
   */
  @ApiModelProperty("消费者外部id")
  @TableField(value = "external_id")
  private String externalId;

  /**
   * 手机号
   *   @Column(name = "phone", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '手机号'")
   */
  @ApiModelProperty("手机号")
  @TableField(value = "phone")
  private String phone;

  /**
   * 昵称
   *   @Column(name = "nickname", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 昵称 '")
   */
  @ApiModelProperty("昵称")
  @TableField(value = "nickname")
  private String nickname;

  /**
   * 姓名
   *   @Column(name = "full_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 姓名 '")
   */
  @ApiModelProperty("姓名")
  @TableField(value = "full_name")
  private String fullName;

  /**
   * 累计分利金额
   *   @Column(name = "cumulative_amount", nullable = true, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 累计分利金额 '")
   */
  @ApiModelProperty("累计分利金额")
  @TableField(value = "cumulative_amount")
  private BigDecimal cumulativeAmount;

  /**
   * 累计分利积分
   *   @Column(name = "cumulative_integral", nullable = true, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 累计分利积分 '")
   */
  @ApiModelProperty("累计分利积分")
  @TableField(value = "cumulative_integral")
  private BigDecimal cumulativeIntegral;

  /**
   * 剩余分利金额
   *   @Column(name = "remainder_amount", nullable = true, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 剩余分利金额 '")
   */
  @ApiModelProperty("剩余分利金额")
  @TableField(value = "remainder_amount")
  private BigDecimal remainderAmount;

  /**
   * 剩余分利积分
   *   @Column(name = "remainder_integral", nullable = true, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 剩余分利积分 '")
   */
  @ApiModelProperty("剩余分利积分")
  @TableField(value = "remainder_integral")
  private BigDecimal remainderIntegral;

  /**
   * 参与次数
   *   @Column(name = "participate_times", nullable = true, columnDefinition = "INT(11) COMMENT ' 参与次数 '")
   */
  @ApiModelProperty("参与次数")
  @TableField(value = "participate_times")
  private Integer participateTimes;

  /**
   * 涉及终端家数
   *   @Column(name = "involve_terminal_count", nullable = true, columnDefinition = "INT(11) COMMENT ' 涉及终端家数 '")
   */
  @ApiModelProperty("涉及终端家数")
  @TableField(value = "involve_terminal_count")
  private Integer involveTerminalCount;

  /**
   * 手机号授权时间
   *   @Column(name = "authorize_time", nullable = false, columnDefinition = "datetime COMMENT '手机号授权时间'")
   */
  @ApiModelProperty("手机号授权时间")
  @TableField(value = "authorize_time")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  private Date authorizeTime;

  /**
   * 省编码
   *   @Column(name = "province_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '省编码'")
   */
  @ApiModelProperty("省编码")
  @TableField(value = "province_code")
  private String provinceCode;

  /**
   * 省名称
   *   @Column(name = "province_name", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '省名称'")
   */
  @ApiModelProperty("省名称")
  @TableField(value = "province_name")
  private String provinceName;

  /**
   * 市编码
   *   @Column(name = "city_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '市编码'")
   */
  @ApiModelProperty("市编码")
  @TableField(value = "city_code")
  private String cityCode;

  /**
   * 市名称
   *   @Column(name = "city_name", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '市名称'")
   */
  @ApiModelProperty("市名称")
  @TableField(value = "city_name")
  private String cityName;

  /**
   * 区编码
   *   @Column(name = "district_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '区编码'")
   */
  @ApiModelProperty("区编码")
  @TableField(value = "district_code")
  private String districtCode;

  /**
   * 区名称
   *   @Column(name = "district_name", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '区名称'")
   */
  @ApiModelProperty("区名称")
  @TableField(value = "district_name")
  private String districtName;

  /**
   * 消费者地址
   *   @Column(name = "consumer_address", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '消费者地址'")
   */
  @ApiModelProperty("消费者地址")
  @TableField(value = "consumer_address")
  private String consumerAddress;

  /**
   * 消费者黑名单状态，默认003（禁用）
   *   @Column(name = "blacklist_status", length = 32, nullable = true, columnDefinition = "varchar(32) COMMENT '消费者黑名单状态'")
   */
  @ApiModelProperty("消费者黑名单状态")
  @TableField(value = "blacklist_status")
  private String blacklistStatus;

  /**
   * 加入黑名单原因
   *   @Column(name = "blacklist_reason", length = 255, nullable = true, columnDefinition = "varchar(255) COMMENT '加入黑名单原因'")
   */
  @ApiModelProperty("加入黑名单原因")
  @TableField(value = "blacklist_reason")
  private String blacklistReason;

  /**
   * 终端code
   */
  @ApiModelProperty("终端code")
  @TableField(exist = false)
  private String terminalCode;

  /**
   * 标签信息
   * @ManyToMany(fetch = FetchType.LAZY,targetEntity = Tag.class)
   *   @JoinTable(
   *       name = "consumer_tag_mapping",
   *       joinColumns = {@JoinColumn(name = "consumer_id")},
   *       inverseJoinColumns = {@JoinColumn(name = "tag_id")})
   */
  @ApiModelProperty("标签信息")
  @TableField(exist = false)
  private Set<Tag> tags;

}
