package com.biz.crm.cps.business.consumer.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.util.Date;

/**
 * 消费者终端关联对象
 * @author songjingen
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ConsumerTerminalMapping", description = "消费者终端关联对象")
@TableName("consumer_terminal_mapping")
public class ConsumerTerminalMapping extends BaseIdEntity {

  /**
   * 
   */
  private static final long serialVersionUID = -6412070145470131817L;

  /**
   * 消费者主键id
   *   @Column(name = "consumer_id", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 消费者主键id '")
   */
  @ApiModelProperty("名称")
  @TableField(value = "consumer_id")
  private String consumerId;

  /**
   * 终端编码
   *   @Column(name = "terminal_code", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 终端编码 '")
   */
  @ApiModelProperty("名称")
  @TableField(value = "terminal_code")
  private String terminalCode;

  /**
   * 创建绑定关系日期
   */
  @ApiModelProperty("创建日期")
  @TableField("create_time")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "create_time", nullable = false, columnDefinition = "date COMMENT '创建日期'")
  private Date createTime;

}
