package com.biz.crm.cps.business.consumer.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.Set;

/**
 * 标签信息
 * @author songjingen
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "Tag", description = "标签信息")
@TableName("tag")
public class Tag extends BaseIdEntity {

  /**
   * 
   */
  private static final long serialVersionUID = -6412070145470131817L;

  /**
   * 分利消费者信息
   *   @ManyToMany(fetch = FetchType.LAZY, mappedBy = "tags")
   */
  @ApiModelProperty("分利消费者信息")
  @TableField(exist = false)
  private Set<Consumer> consumers;

  /**
   * 名称
   *   @Column(name = "tag_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 名称 '")
   */
  @ApiModelProperty("名称")
  @TableField(value = "tag_name")
  private String tagName;

}
