package com.biz.crm.cps.business.consumer.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.consumer.local.entity.Consumer;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * Consumer 的 mybatis 操作接口
 * @author songjingen
 */
public interface ConsumerMapper extends BaseMapper<Consumer> {

  /**
   * 分页条件查询
   * @param page
   * @param dto
   * @return
   */
  Page<Consumer> findByConditions(Page<Consumer> page, @Param("dto") ConsumerDto dto);

  /**
   * 查询终端下所有的消费者
   * @param terminalCode
   * @return
   */
  List<Consumer> findByTerminalCode(@Param("terminalCode") String terminalCode);
}
