package com.biz.crm.cps.business.consumer.local.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerCountDto;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerDto;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import org.apache.ibatis.annotations.Param;

/**
 * ConsumerVo 的 mybatis 操作接口
 * @Author dy
 * @DATE 2022/4/1
 **/
public interface ConsumerVoMapper {

  /**
   * 分页条件查询
   * @param page
   * @param dto
   * @return
   */
  Page<ConsumerVo> findByConditions(@Param("page") Page<ConsumerVo> page, @Param("dto") ConsumerDto dto);

  /**
   * 多条件查询消费者数量
   * @param dto
   * @return
   */
  Integer countByConsumerCountDto(@Param("dto") ConsumerCountDto dto);
}
