package com.biz.crm.cps.business.consumer.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.consumer.local.entity.Consumer;
import com.biz.crm.cps.business.consumer.local.entity.Tag;
import com.biz.crm.cps.business.consumer.local.mapper.ConsumerMapper;
import com.biz.crm.cps.business.consumer.local.mapper.TagMapper;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerDto;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 分利消费者的组装sql类
 * @author songjingen
 */
@Component
public class ConsumerRepository  extends ServiceImpl<ConsumerMapper, Consumer> {

  @Resource
  private ConsumerMapper consumerMapper;
  @Resource
  private TagMapper tagMapper;

  /**
   * 分页条件查询
   * @param dto
   * @return
   */
  public Page<Consumer> findByConditions(Pageable pageable, ConsumerDto dto) {
    Page<Consumer> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<Consumer> selectPage = consumerMapper.findByConditions(page, dto);
    return selectPage;
  }

  /**
   * 根据消费者主键查询标签信息
   * @param consumerId
   * @return
   */
  public Set<Tag> findByConsumerId(String consumerId) {
    return tagMapper.findByConsumerId(consumerId);
  }

  /**
   * 根据id去批量操作修改黑名单状态
   * @param ids
   * @param blacklistReason
   * @param enable
   */
  public void updateBlacklistStatusByIds(List<String> ids, String blacklistReason, String accountName, EnableStatusEnum enable) {
    UpdateWrapper<Consumer> updateWrapper = new UpdateWrapper<>();
    updateWrapper.set("blacklist_status", enable.getCode());
    updateWrapper.set("modify_account", accountName);
    updateWrapper.set("modify_time", new Date());
    updateWrapper.set("blacklist_reason", blacklistReason);
    updateWrapper.in("id", ids);
    this.update(updateWrapper);
  }

  /**
   * 根据id去批量查询数据
   * @param ids
   */
  public List<Consumer> findByIds(List<String> ids) {
    QueryWrapper<Consumer> queryWrapper = new QueryWrapper<>();
    queryWrapper.in("id", ids);
    return this.list(queryWrapper);
  }

  /**
   * 通过消费者外部id获取对象
   * @param externalId
   * @return
   */
  public Consumer findByExternalId(String externalId) {
    QueryWrapper<Consumer> queryWrapper = new QueryWrapper<>();
    queryWrapper.eq("external_id", externalId);
    return this.getOne(queryWrapper);
  }

  /**
   * 通过编码查询
   * @param consumerCode
   * @return
   */
  public Consumer findByConsumerCode(String consumerCode) {
    QueryWrapper<Consumer> queryWrapper = new QueryWrapper<>();
    queryWrapper.eq("consumer_code", consumerCode);
    return this.getOne(queryWrapper);
  }

  /**
   * 查询终端下所有的消费者
   * @param terminalCode
   * @return
   */
  public List<Consumer> findByTerminalCode(String terminalCode) {
    return consumerMapper.findByTerminalCode(terminalCode);
  }
}
