package com.biz.crm.cps.business.consumer.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.consumer.local.entity.ConsumerTerminalMapping;
import com.biz.crm.cps.business.consumer.local.mapper.ConsumerTerminalMappingMapper;
import org.springframework.stereotype.Component;

/**
 * 消费者关联表相关数据库操作
 * @author songjingen
 */
@Component
public class ConsumerTerminalMappingRepository extends ServiceImpl<ConsumerTerminalMappingMapper, ConsumerTerminalMapping> {

  /**
   * 根据对象查询信息
   * @param consumerTerminalMapping
   * @return
   */
  public ConsumerTerminalMapping findByConsumerTerminalMapping(ConsumerTerminalMapping consumerTerminalMapping) {
    QueryWrapper<ConsumerTerminalMapping> queryWrapper = new QueryWrapper<>();
    queryWrapper.eq("consumer_id", consumerTerminalMapping.getConsumerId());
    queryWrapper.eq("terminal_code", consumerTerminalMapping.getTerminalCode());
    return this.getOne(queryWrapper);
  }
}
