package com.biz.crm.cps.business.consumer.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.consumer.local.mapper.ConsumerVoMapper;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerCountDto;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerDto;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 分利消费者的组装sql类
 * @Author dy
 * @DATE 2022/4/1
 **/
@Component
public class ConsumerVoRepository {

  @Autowired
  private ConsumerVoMapper consumerVoMapper;

  /**
   * 分页条件查询
   * @param dto
   * @return
   */
  public Page<ConsumerVo> findByConditions(Pageable pageable, ConsumerDto dto) {
    Page<ConsumerVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<ConsumerVo> selectPage = consumerVoMapper.findByConditions(page, dto);
    return selectPage;
  }

  /**
   * 多条件查询数量
   * @param dto
   * @return
   */
  public Integer countByConsumerCountDto(ConsumerCountDto dto){
    return this.consumerVoMapper.countByConsumerCountDto(dto);
  }
}
