package com.biz.crm.cps.business.consumer.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.consumer.local.entity.Consumer;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 分利消费者相关的业务接口
 * @author songjingen
 */
public interface ConsumerService {

  /**
   * 创建一个新的Consumer模型对象（包括了可能的第三方系统调用、复杂逻辑处理等）
   * @param consumer
   * @return Consumer
   */
  Consumer create(Consumer consumer);

  /**
   * 根据分利消费者主键ID，查询成功后返回分利消费者的基本信息、标签信息、关联终端信息
   * @param id
   * @return Consumer
   */
  Consumer findDetailsById(String id);

  /**
   * 只是（分页）查询分利消费者的基本信息，不会包括OneToMany/ManyToMany/ManyToOne的关联信息
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<Consumer> findByConditions(Pageable pageable, ConsumerDto dto);

  /**
   * 加入黑名单(单个或批量)
   * @param ids
   * @param blacklistReason
   */
  void enable(List<String> ids, String blacklistReason);

  /**
   * 移除黑名单(单个或批量)
   * @param ids
   */
  void disable(List<String> ids);

  /**
   * 根据分利消费者编码，查询成功后返回分利消费者的基本信息、标签信息、关联终端信息
   * @param externalId
   * @return
   */
  Consumer findDetailsByExternalId(String externalId);

  /**
   * 根据外部id查询消费者信息
   * @param externalId
   * @return
   */
  Consumer findByExternalId(String externalId);

  /**
   * 根据消费者编码查询消费者信息
   * @param consumerCode
   * @return
   */
  Consumer findByConsumerCode(String consumerCode);

  /**
   * 根据终端编码查询消费者集合
   * @param terminalCode
   * @return
   */
  List<Consumer> findByTerminalCode(String terminalCode);
}
