package com.biz.crm.cps.business.consumer.local.service.internal;

import com.biz.crm.cps.business.consumer.local.entity.ConsumerTerminalMapping;
import com.biz.crm.cps.business.consumer.local.repository.ConsumerTerminalMappingRepository;
import com.biz.crm.cps.business.consumer.local.service.ConsumerTerminalMappingService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.Objects;

/**
 * 消费者终端关联service实现类
 * @author songjingen
 */
@Service
public class ConsumerTerminalMappingServiceImpl implements ConsumerTerminalMappingService {

  @Autowired
  private ConsumerTerminalMappingRepository consumerTerminalMappingRepository;
  /**
   * 创建消费者终端关联信息
   * @param consumerTerminalMapping
   */
  @Transactional
  @Override
  public void create(ConsumerTerminalMapping consumerTerminalMapping) {
    this.createValidation(consumerTerminalMapping);
    //未查询到信息则进行新增操作
    ConsumerTerminalMapping mapping = this.findByConsumerTerminalMapping(consumerTerminalMapping);
    if (Objects.nonNull(mapping)) {
      throw new RuntimeException("新增操作时，当前消费者已绑定此终端！");
    }
    consumerTerminalMapping.setCreateTime(new Date());
    this.consumerTerminalMappingRepository.save(consumerTerminalMapping);
  }

  /**
   * 根据对象查询信息
   * @param consumerTerminalMapping
   * @return
   */
  @Override
  public ConsumerTerminalMapping findByConsumerTerminalMapping(ConsumerTerminalMapping consumerTerminalMapping) {
    if (Objects.isNull(consumerTerminalMapping)) {
      return null;
    }
    return this.consumerTerminalMappingRepository.findByConsumerTerminalMapping(consumerTerminalMapping);
  }

  /**
   * 新增时，验证信息
   * @param consumerTerminalMapping
   */
  private void createValidation(ConsumerTerminalMapping consumerTerminalMapping) {
    Validate.notNull(consumerTerminalMapping, "新增时，消费者终端关联对象不能空！");
    Validate.notNull(consumerTerminalMapping.getConsumerId(), "新增操作时，消费者主键不能为空！");
    Validate.notNull(consumerTerminalMapping.getTerminalCode(), "新增操作时，终端编码不能为空！");
  }
}
