package com.biz.crm.cps.business.consumer.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.consumer.local.entity.Consumer;
import com.biz.crm.cps.business.consumer.local.repository.ConsumerVoRepository;
import com.biz.crm.cps.business.consumer.local.service.ConsumerService;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerCountDto;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerDto;
import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

/**
 * 消费者voService实现类
 * @author songjingen
 */
@Service
public class ConsumerVoServiceImpl implements ConsumerVoService {

  @Autowired
  private ConsumerService consumerService;
  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private ConsumerVoRepository consumerVoRepository;
  /**
   * 通过消费者外部id获取对象
   * @param externalId
   * @return
   */
  @Override
  public ConsumerVo findByExternalId(String externalId) {
    if(StringUtils.isBlank(externalId)){
      return null;
    }
    Consumer consumer = this.consumerService.findByExternalId(externalId);
    if (consumer == null) {
      return null;
    }
    ConsumerVo consumerVo = this.nebulaToolkitService.copyObjectByWhiteList(consumer, ConsumerVo.class, HashSet.class, ArrayList.class);
    return consumerVo;
  }

  /**
   * 通过编码查询
   * @param consumerCode
   * @return
   */
  @Override
  public ConsumerVo findByConsumerCode(String consumerCode) {
    if(StringUtils.isBlank(consumerCode)){
      return null;
    }
    Consumer consumer = this.consumerService.findByConsumerCode(consumerCode);
    if(consumer == null){
      return null;
    }
    ConsumerVo consumerVo = this.nebulaToolkitService.copyObjectByWhiteList(consumer, ConsumerVo.class, HashSet.class, ArrayList.class);
    return consumerVo;
  }

  /**
   * 查询终端下所有的消费者
   * @param terminalCode
   * @return
   */
  @Override
  public List<ConsumerVo> findByTerminalCode(String terminalCode) {
    if(StringUtils.isBlank(terminalCode)){
      return Lists.newArrayList();
    }
    List<Consumer> list = this.consumerService.findByTerminalCode(terminalCode);
    if(CollectionUtils.isEmpty(list)){
      return Lists.newArrayList();
    }
    Collection<ConsumerVo> consumerVos = this.nebulaToolkitService.copyCollectionByWhiteList(list, Consumer.class, ConsumerVo.class, HashSet.class, ArrayList.class);
    return Lists.newArrayList(consumerVos);
  }

  /**
   * 多条件查询消费者数量
   * @param dto
   * @return
   */
  @Override
  public Integer countByConsumerCountDto(ConsumerCountDto dto) {
    if(dto == null) {
      dto = new ConsumerCountDto();
    }
    return this.consumerVoRepository.countByConsumerCountDto(dto);
  }
}
