package com.biz.crm.cps.business.consumer.local.service.notifier;

import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.consumer.local.entity.Consumer;
import com.biz.crm.cps.business.consumer.local.entity.ConsumerTerminalMapping;
import com.biz.crm.cps.business.consumer.local.service.ConsumerService;
import com.biz.crm.cps.business.consumer.local.service.ConsumerTerminalMappingService;
import com.biz.crm.cps.external.barcode.sdk.dto.ConsumerScanCodeDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import com.biz.crm.cps.external.barcode.sdk.event.ConsumerScanCodeRecordEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 实现模块【外部扫码】的消费者扫码事件接口
 * @author songjingen
 */
@Component
public class ConsumerScanCodeRecordEventListenerImpl implements ConsumerScanCodeRecordEventListener {

  @Autowired
  private ConsumerService consumerService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private ConsumerTerminalMappingService consumerTerminalMappingService;
  /**
   * 消费者扫码成功时，消费者模块进行创建用户操作
   * 1、如果消费者已存在则不创建，并验证消费者是否加入黑名单，是-直接报错不允许扫码
   * 2、已存在未加入黑名单，当前终端未绑定，则绑定当前终端
   * 3、消费者不存在创建消费者
   * @param dto
   */
  @Override
  public void onSuccessScan(ScanCodeRecordEventDto dto) {
    Validate.notNull(dto, "扫码事件对象不能为空！");
    ConsumerScanCodeDto consumerScanCodeDto = dto.getConsumerScanCodeDto();
    Validate.notNull(consumerScanCodeDto, "扫码事件消费者对象不能为空！");
    Consumer consumer = this.consumerService.findDetailsByExternalId(consumerScanCodeDto.getExternalId());
    if (Objects.nonNull(consumer)) {
      // 1、======
      Validate.isTrue(!EnableStatusEnum.ENABLE.equals(consumer.getBlacklistStatus()), "消费者扫码时，当前消费者已加入黑名单！");
      // 2、======
      if (StringUtils.isBlank(consumerScanCodeDto.getBarCodeParticipatorCode())) {
        return;
      }
      ConsumerTerminalMapping consumerTerminalMapping = new ConsumerTerminalMapping();
      consumerTerminalMapping.setConsumerId(consumer.getId());
      consumerTerminalMapping.setTerminalCode(consumerScanCodeDto.getBarCodeParticipatorCode());
      ConsumerTerminalMapping mapping = this.consumerTerminalMappingService.findByConsumerTerminalMapping(consumerTerminalMapping);
      if (Objects.isNull(mapping)) {
        this.consumerTerminalMappingService.create(consumerTerminalMapping);
      }
    } else {
      // 3、======
      Consumer newConsumer = this.nebulaToolkitService.copyObjectByWhiteList(consumerScanCodeDto, Consumer.class, null, null);
      newConsumer.setTerminalCode(consumerScanCodeDto.getBarCodeParticipatorCode());
      this.consumerService.create(newConsumer);
    }

  }

  @Override
  public void onFailScan(ScanCodeRecordEventDto dto) {

  }
}
